﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		

    protected void dc_ContextLoad(object sender, EventArgs e) {
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
        DaneFirmy(ph);
        labelStanowisko.EditValue = GetStanowisko(ph);
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }
    
    void DaneFirmy(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string nazwa = core.Config.Firma.Pieczątka.Nazwa;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
        }
        PieczątkaNazwa.EditValue = nazwa;
    }
            
</script>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Wypadek</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" TypeName="Soneta.Kadry.Wypadek,Soneta.KadryPlace" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="<center>Karta rejestracji wypadku</center>" runat="server"
				DataMember0="."></eb:ReportHeader>
			<p>
				1. Poszkodowany:
				<ea:DataLabel id="DataLabel1" runat="server" DataMember="PracHistoria.Nazwisko"></ea:DataLabel>
				<ea:DataLabel id="DataLabel16" runat="server" DataMember="PracHistoria.Imie"></ea:DataLabel>
				<br>
				ur.<ea:DataLabel id="DataLabel2" runat="server" DataMember="PracHistoria.Urodzony.Data"></ea:DataLabel>
			</p>
			<p>
				2. Zatrudniony w:
				<ea:DataLabel id="PieczątkaNazwa" runat="server"></ea:DataLabel>
			</p>
			<p>
				3. Miejsce zdarzenia:
				<ea:DataLabel id="DataLabel24" runat="server" DataMember="Miejsce"></ea:DataLabel>
				,&nbsp;stanowisko:
				<ea:DataLabel id="labelStanowisko" runat="server"></ea:DataLabel>
			</p>
			<p>
				4. Data wypadku:
				<ea:DataLabel id="DataLabel3" runat="server" DataMember="Data"></ea:DataLabel>
				, godz
				<ea:DataLabel id="DataLabel4" runat="server" DataMember="Godzina"></ea:DataLabel>
			</p>
			<p>
				5. Rodzaj wypadku:
				<ea:DataLabel id="DataLabel5" runat="server" DataMember="Rodzaj">
					<ValuesMap>
						<ea:ValuesPair Key="Indywidualny" Value="indywidualny"></ea:ValuesPair>
						<ea:ValuesPair Key="Zbiorowy" Value="zbiorowy"></ea:ValuesPair>
					</ValuesMap>
				</ea:DataLabel>
				<ea:DataLabel id="DataLabel6" runat="server" DataMember="Smiertelny">
					<ValuesMap>
						<ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
						<ea:ValuesPair Key="True" Value=", śmiertelny"></ea:ValuesPair>
					</ValuesMap>
				</ea:DataLabel>
				<ea:DataLabel id="DataLabel7" runat="server" DataMember="Ciezki">
					<ValuesMap>
						<ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
						<ea:ValuesPair Key="True" Value=", ciężki"></ea:ValuesPair>
					</ValuesMap>
				</ea:DataLabel>
				<ea:DataLabel id="DataLabel8" runat="server" DataMember="Niezdolnosc">
					<ValuesMap>
						<ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
						<ea:ValuesPair Key="True" Value=", powodujący czasową niezdolność do pracy"></ea:ValuesPair>
					</ValuesMap>
				</ea:DataLabel>
			</p>
			<p>
				6. Numer protokołu:
				<ea:DataLabel id="DataLabel9" runat="server" DataMember="ProtokolNumer"></ea:DataLabel>
				, data sporządzenia:
				<ea:DataLabel id="DataLabel10" runat="server" DataMember="ProtokolData"></ea:DataLabel>
			</p>
			<p>
				7. Numer SKW:
				<ea:DataLabel id="DataLabel11" runat="server" DataMember="SKW"></ea:DataLabel>
			</p>
			<p>
				8. Ustalono następujące okoliczności i przyczyny wypadku:<BR>
				<ea:DataLabel id="DataLabel26" runat="server" DataMember="Okolicznosci"></ea:DataLabel>
			</p>
			<P>
				9. Stwierdza się, że powyższy wypadek :
				<ea:DataLabel id="DataLabel13" runat="server" DataMember="PrzyPracy">
					<ValuesMap>
						<ea:ValuesPair Key="False" Value="NIE JEST"></ea:ValuesPair>
						<ea:ValuesPair Key="True" Value="JEST"></ea:ValuesPair>
					</ValuesMap>
				</ea:DataLabel>
				<br>
				- wypadkiem przy pracy, wypadkiem zrównanym z wypadkiem przy pracy<br>
				- wypadkiem przy wykonywaniu umowy agencyjnej lub umowy zlecenia</P>
			<P>10. Skutki wypadku (miejsce i rodzaj urazu):<BR>
				<ea:DataLabel id="DataLabel12" runat="server" DataMember="Skutki"></ea:DataLabel></P>
			<P>11. Przekazanie wniosku ZUS<br>
				<table width="100%">
					<tbody>
						<tr>
							<td width="5%">
							</td>
							<td width="40%">
								- Numer pisma:
								<ea:DataLabel id="DataLabel15" runat="server" DataMember="PismoNumer"></ea:DataLabel>
								&nbsp;</td>
							<td>
								, data:&nbsp;<ea:DataLabel id="DataLabel22" runat="server" DataMember="PismoData"></ea:DataLabel>
							</td>
						</tr>
						<tr>
							<td>
							</td>
							<td>
								- Numer decyzji ZUS:
								<ea:DataLabel id="DataLabel18" runat="server" DataMember="DecyzjaNumer"></ea:DataLabel>
							</td>
							<td>
								, data:
								<ea:DataLabel id="DataLabel19" runat="server" DataMember="DecyzjaData"></ea:DataLabel>
							</td>
						</tr>
						<tr>
							<td>
							</td>
							<td>
								- % uszczerbku na zdrowiu:
								<ea:DataLabel id="DataLabel20" runat="server" DataMember="Uszczerbek"></ea:DataLabel>
							</td>
							<td>
							</td>
						</tr>
						<tr>
							<td>
							</td>
							<td>
								- Kwota:
								<ea:DataLabel id="DataLabel21" runat="server" DataMember="Kwota" Format="{0:n}"></ea:DataLabel>
							</td>
							<td>
							</td>
						</tr>
					</tbody>
				</table>
			</P>
			<p>
				12. Przyczyna odmowy odszkodowania przez ZUS:<BR>
				<ea:DataLabel id="DataLabel14" runat="server" DataMember="Odmowa"></ea:DataLabel>
			</p>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False">
				<Subtitles>
					<eb:FooterSubtitle SubtitleType="Empty" Width="50"></eb:FooterSubtitle>
					<eb:FooterSubtitle Caption="Data i podpis osoby upoważnionej" Width="50"></eb:FooterSubtitle>
				</Subtitles>
			</eb:ReportFooter>
		</form>
	</body>
</HTML>
